<div>
    <div class="bg-white p-4 shadow-sm rounded-lg mb-6 border border-gray-200 dark:border-white/10 classic:border-black">
        <!-- Summary Header -->
        <h3 class="text-lg font-semibold border-b border-gray-200  dark:border-white/10 classic:border-black pb-2 mb-4">{{ __('messages.t_summary') }}</h3>

        <!-- Dynamic Package Details -->
        @foreach ($packageItems as $item)
        <div wire:key='summary-package-{{ $item->id }}' class="flex justify-between py-1">
            <span>
                @if($item->promotion)
                    {{ __('messages.t_promotion_name_for_days', ['quantity' => $item->quantity, 'promotionName' => $item->promotion->promotion->name, 'days' => $item->promotion->package->duration]) }}
                @else
                    {{ __('messages.t_ads_valid_for_days', ['quantity' => $item->quantity, 'days' => $item->package->duration]) }}
                @endif
            </span>

            <!-- Display the price, using the offer price if available and within the offer date range -->
            @php
                $today = \Illuminate\Support\Carbon::now();
                $isOfferValid = $item->offer_enabled && $item->offer_price && $today->between($item->offer_start, $item->offer_end);
            @endphp

            <span>
                @if($isOfferValid)
                    <s>{{ config('app.currency_symbol') }}{{ \Number::format(floatval($item->price), locale: $paymentSettings->currency_locale) }}</s>
                    {{ config('app.currency_symbol') }}{{ \Number::format(floatval($item->offer_price), locale: $paymentSettings->currency_locale) }}
                @else
                    {{ config('app.currency_symbol') }}{{ \Number::format(floatval($item->price), locale: $paymentSettings->currency_locale) }}
                @endif
            </span>
        </div>
        @endforeach

        <!-- Divider -->
        <div class="border-t my-3 border-gray-200  dark:border-white/10 classic:border-black"></div>

        <!-- Subtotal -->
        <div class="flex justify-between py-1">
            <span class="font-semibold">{{ __('messages.t_subtotal') }}</span>
            <span>{{config('app.currency_symbol')}}{{ \Number::format(floatval($subtotal), locale: $paymentSettings->currency_locale) }}</span>
        </div>

        <!-- Tax -->
        <div class="flex justify-between py-1">
            <span>{{ __('messages.t_tax') }}</span>
            <span>{{config('app.currency_symbol')}}{{ \Number::format(floatval($tax), locale: $paymentSettings->currency_locale) }}</span>
        </div>

        <!-- Divider -->
        <div class="border-t my-3 border-gray-200  dark:border-white/10 classic:border-black"></div>

        <!-- Total -->
        <div class="flex justify-between py-1">
            <span class="font-semibold text-lg">{{ __('messages.t_total') }}</span>
            <span class="font-semibold text-lg">{{ config('app.currency_symbol') }}{{ \Number::format(floatval($total), locale: $paymentSettings->currency_locale) }}</span>
        </div>

        {{-- Exchange Rate --}}
        @if ($this->defaultCurrency && $this->isDifferentRate)
            <div class="flex justify-between py-1">
                <span class="font-semibold text-lg">{{ __('messages.t_total_including_exchange_rate') }}</span>
                <span class="font-semibold text-lg">{{ $this->getExchangeCurrencySymbol() }}{{ \Number::format(floatval($this->convertedTotal), locale: $paymentSettings->currency_locale) }}</span>
            </div>
        @endif
    </div>

    <h3 class="mb-6">{{ __('messages.t_choose_payment_label') }}</h3>
    <form wire:submit>
        <div class="mb-5 payment-methods">
            {{ $this->form }}
        </div>
        @if ($currentPayment)
          <livewire:dynamic-component  :key="$currentPayment" :component="$currentPayment" :data="$this->paymentData"   :total="$this->defaultCurrency && $this->isDifferentRate ? $this->convertedTotal : $total"  :$id :$subtotal :$tax :$type />
        @endif
    </form>
</div>
