<?php

namespace Adfox\LoginOtp\Filament\Pages;

use App\Settings\LoginOtpSettings;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\Toggle;
use Filament\Forms\Form;
use Filament\Pages\SettingsPage;
use Filament\Forms\Components\Placeholder;
use Filament\Forms\Components\Textarea;
use Illuminate\Support\Facades\Config;

class LoginOtp extends SettingsPage
{
    protected static ?string $title = 'Login OTP Settings';

    protected static ?string $navigationGroup = 'Settings';

    protected static ?string $navigationLabel = 'Login Otp';

    protected static ?string $slug = 'manage-login-otp-settings';

    protected static string $settings = LoginOtpSettings::class;

    protected static ?int $navigationSort = 11; // Adjust the sort order as needed

    protected function mutateFormDataBeforeSave(array $data): array
    {
        $previousData = app(LoginOtpSettings::class);
        $filtered = [];

        foreach ($data as $key => $item) {
            if (property_exists($previousData, $key)) {
                $propertyType = gettype($previousData->$key);
                if (is_null($item) && $propertyType === 'string') {
                    $filtered[$key] = '';
                    continue;
                }
            }
            $filtered[$key] = $item;
        }
        return $filtered;
    }

    public function form(Form $form): Form
    {
        $isDemo = Config::get('app.demo');
        return $form
            ->schema([

                Toggle::make('enabled')
                ->label('Enable OTP')
                ->helperText('Toggle to enable or disable OTP for login.'),

                $isDemo ?
                Placeholder::make('twilio_sid')
                    ->label('Twilio SID')
                    ->content('*****')
                    ->hint('Hidden due to demo mode.') :
                TextInput::make('twilio_sid')
                    ->label('Twilio SID')
                    ->required()
                    ->helperText('Your Twilio Account SID.'),

                $isDemo ?
                Placeholder::make('auth_token')
                    ->label('Auth Token')
                    ->content('*****')
                    ->hint('Hidden due to demo mode.') :
                TextInput::make('auth_token')
                    ->label('Auth Token')
                    ->required()
                    ->helperText('Your Twilio Auth Token.'),

                TextInput::make('from_number')
                    ->label('From Number')
                    ->required()
                    ->helperText('The phone number from which OTP messages are sent.'),

            ])
            ->columns(2);
    }
}
