<?php

namespace Adfox\LiveChat\Filament\Pages;

use App\Settings\PaypalSettings;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\Toggle;
use Filament\Forms\Form;
use Filament\Pages\SettingsPage;
use Illuminate\Support\Facades\Config;
use App\Settings\LiveChatSettings;
use Filament\Forms\Components\Placeholder;
use Illuminate\Support\Facades\Artisan;

class LiveChat extends SettingsPage
{
    protected static ?string $title = 'Live Chat Settings';

    protected static ?string $navigationGroup = 'Settings';

    protected static ?string $navigationLabel = 'Live Chat';

    protected static ?string $slug = 'manage-livechat-settings';

    protected static string $settings = LiveChatSettings::class;

    protected static ?int $navigationSort = 12; // Adjust the sort order as needed


    protected function mutateFormDataBeforeSave(array $data): array
    {
        $previousData = app(LiveChatSettings::class);
        $filtered = [];

        foreach ($data as $key => $item) {
            if (property_exists($previousData, $key)) {
                $propertyType = gettype($previousData->$key);
                if ($key == 'pusher_key') {
                    Config::write('chatify.pusher.key', $item);
                }
                if ($key === 'pusher_secret') {
                    Config::write('chatify.pusher.secret', $item);
                }
                if ($key === 'pusher_app_id') {
                    Config::write('chatify.pusher.app_id', $item);
                }
                if ($key === 'pusher_cluster') {
                    Config::write('chatify.pusher.options.cluster', $item);
                }
                if ($key === 'encryption') {
                    Config::write('chatify.pusher.options.encrypted', $item);
                }
                if (is_null($item) && $propertyType === 'string') {
                    $filtered[$key] = '';
                    continue;
                }
            }
            $filtered[$key] = $item;
        }
        // Clear cache
        Artisan::call('config:clear');
        return $filtered;
    }

    public function form(Form $form): Form
    {
        $isDemo = Config::get('app.demo');
        return $form
            ->schema([
                Toggle::make('enable_livechat')
                    ->label('Enable Livechat')
                    ->helperText('Toggle to activate or deactivate the Livechat.'),

                $isDemo ?
                Placeholder::make('pusher_key')
                    ->label('Pusher Key')
                    ->content('*****')
                    ->hint('Hidden due to demo mode.') :
                TextInput::make('pusher_key')
                    ->label('Pusher Key')
                    ->required()
                    ->helperText('Your Pusher App Key.'),
                $isDemo ?
                Placeholder::make('pusher_secret')
                    ->label('Pusher Secret')
                    ->content('*****')
                    ->hint('Hidden due to demo mode.') :
                TextInput::make('pusher_secret')
                    ->label('Pusher Secret')
                    ->required()
                    ->helperText('Your Pusher App Secret.'),

                $isDemo ?
                Placeholder::make('pusher_app_id')
                        ->label('Pusher App ID')
                        ->content('*****')
                        ->hint('Hidden due to demo mode.') :
                TextInput::make('pusher_app_id')
                    ->label('Pusher App ID')
                    ->required()
                    ->helperText('Your Pusher App ID.'),

                TextInput::make('pusher_cluster')
                    ->label('Pusher Cluster')
                    ->required()
                    ->helperText('Your Pusher Cluster.'),

                Toggle::make('encryption')
                    ->label('Enable Encryption')
                    ->helperText('Toggle to enable or disable encryption.'),

                Toggle::make('enable_uploading_attachments')
                    ->label('Enable Uploading Attachments')
                    ->helperText('Allow users to upload attachments in chat.'),

                Toggle::make('enable_emojis')
                    ->label('Enable Emojis')
                    ->helperText('Allow emojis in chat messages.'),


                Toggle::make('enable_audio_recording')
                    ->label('Enable Audio Recording')
                    ->helperText('Toggle to enable or disable audio recording in live chats.'),


                Toggle::make('play_new_message_sound')
                    ->label('Play New Message Sound')
                    ->helperText('Play a sound for new messages.'),

                TextInput::make('allowed_image_extensions')
                    ->label('Allowed Image Extensions')
                    ->required()
                    ->helperText('Extensions allowed for image uploads, comma-separated.'),

                TextInput::make('allowed_file_extensions')
                    ->label('Allowed File Extensions')
                    ->required()
                    ->helperText('Extensions allowed for file uploads, comma-separated.'),

                TextInput::make('max_file_size')
                    ->label('Max File Size')
                    ->numeric()
                    ->required()
                    ->helperText('Maximum file size for uploads in mb.')
            ])
            ->columns(2);
    }
}
