<?php

namespace Adfox\Feedback\Filament\Resources;

use Adfox\Feedback\Filament\Resources\FeedbackResource\Pages;
use Adfox\Feedback\Filament\Resources\FeedbackResource\RelationManagers;
use App\Models\Feedback;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Actions\Action;
use Filament\Tables\Columns\SelectColumn;
use Filament\Tables\Columns\TextColumn;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;

class FeedbackResource extends Resource
{
    protected static ?string $model = Feedback::class;

    protected static ?string $navigationGroup = 'Feedback Management';

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                //
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->modifyQueryUsing(fn (Builder $query) => $query->latest())
            ->columns([
            TextColumn::make('buyer.name')
                ->label('Buyer')
                ->searchable()
                ->sortable(),
            TextColumn::make('seller.name')
                ->label('Seller')
                ->searchable()
                ->sortable(),
            TextColumn::make('experience')
                ->label('Experience')
                ->badge()
                ->colors([
                    'success' => 'positive',
                    'warning' => 'neutral',
                    'danger' => 'negative',
                ]),
            SelectColumn::make('interaction')
                ->disabled()
                ->options([
                    'successful_purchase' => __('messages.t_successful_purchase'),
                    'deal_failed' => __('messages.t_deal_failed'),
                    'didnt_come_to_deal' => __('messages.t_didnt_come_to_deal'),
                    'cant_reach_seller' => __('messages.t_cant_reach_seller'),
                ])
                ->selectablePlaceholder(false),
                TextColumn::make('detail')
                    ->label('Detail')
                    ->limit(50)
                    ->searchable(),
                TextColumn::make('created_at')
                    ->label('Posted On')
                    ->date()
                    ->sortable(),
                TextColumn::make('likes_count')
                    ->counts('likes')
                    ->label('Likes')
                    ->sortable(),
                TextColumn::make('replies_count')
                    ->counts('replies')
                    ->label('Replies')
                    ->sortable(),
            ])
            ->filters([
                //
            ])
            ->actions([
                Action::make('view')
                ->icon('heroicon-o-eye')
                ->label('View Details')
                ->url(fn (Feedback $record): string =>  route('feedback', [
                    'id' => $record->seller_id
                ]))
                ->openUrlInNewTab(),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListFeedback::route('/'),
            'create' => Pages\CreateFeedback::route('/create'),
            'edit' => Pages\EditFeedback::route('/{record}/edit'),
        ];
    }
}
