<?php

namespace Adfox\Feedback\Filament\Pages;

use App\Settings\FeedbackSettings;
use Filament\Forms\Components\Toggle;
use Filament\Forms\Form;
use Filament\Pages\SettingsPage;

class ManageFeedbackSettings extends SettingsPage
{
    protected static ?string $title = 'Feedback Settings';

    protected static ?string $navigationGroup = 'Feedback Management';

    protected static ?string $navigationLabel = 'Feedback Settings';

    protected static ?string $slug = 'manage-feedback-settings';

    protected static string $settings = FeedbackSettings::class;

    protected static ?int $navigationSort = 13;

    public function form(Form $form): Form
    {
        return $form
            ->schema([
                Toggle::make('enable_feedback')
                    ->label('Enable Feedback')
                    ->helperText('Toggle to activate or deactivate the feedback feature.'),

                Toggle::make('enable_replies')
                    ->label('Enable Replies')
                    ->helperText('Allow users to reply to feedback.'),

                Toggle::make('enable_likes')
                    ->label('Enable Likes')
                    ->helperText('Allow users to like feedback.'),
            ])
            ->columns(2);
    }
}
