<?php

namespace Adfox\Appearance\Filament\Resources\BannerResource\Widgets;

use App\Models\BannerAnalytics;
use Carbon\Carbon;
use Filament\Widgets\ChartWidget;
use Illuminate\Support\Facades\DB;

class DailyBannerClicksChart extends ChartWidget
{
    protected static ?string $heading = 'Daily Banner Click';
    public $bannerId;
    protected function getData(): array
    {
        $startOfMonth = Carbon::now()->startOfMonth();
        $endOfMonth = Carbon::now()->endOfMonth();

        // Get daily view and click counts for the specified banner
        $data = BannerAnalytics::select(
                DB::raw('DATE(created_at) as date'),
                DB::raw('SUM(CASE WHEN event = "click" THEN 1 ELSE 0 END) as clicks')
            )
            ->where('banner_id', $this->bannerId)
            ->whereBetween('created_at', [$startOfMonth, $endOfMonth])
            ->groupBy('date')
            ->orderBy('date')
            ->get();

            // Prepare data for chart
            $dates = $data->pluck('date');
            $clicks = $data->pluck('clicks');
        return [
            'datasets' => [
                [
                    'label' => 'Click',
                    'data' => $clicks,
                    'backgroundColor' => '#36A2EB',
                    'borderColor' => '#9BD0F5',
                ],
            ],
            'labels' => $dates,
        ];
    }

    protected function getType(): string
    {
        return 'bar';
    }
}
