<?php

namespace Adfox\Appearance\Filament\Pages;

use Adfox\Appearance\Enums\HomePageSectionType;
use App\Settings\HomeSettings;
use Filament\Forms;
use Filament\Forms\Components\Repeater;
use Filament\Forms\Components\Section;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Form;
use Filament\Pages\SettingsPage;

class ManageHome extends SettingsPage
{
    protected static ?string $navigationGroup = 'Appearance';
    protected static ?string $title = 'Home Settings';
    protected static ?string $navigationLabel = 'Home Settings';

    protected static string $settings = HomeSettings::class;


    public function form(Form $form): Form
    {
        return $form
            ->schema([
                Section::make('Home Page Sections Order ')
                ->description('Customize the order of the home page sections.')
                ->schema([
                Repeater::make('section_data')
                ->addable(false)
                ->disableLabel()
                ->extraAttributes(['class' => 'home_page_section'])
                ->reorderableWithButtons()
                ->deletable(false)
                ->schema([
                    // TextInput::make('title')
                ])
                ->itemLabel(fn (array $state): ?string => HomePageSectionType::getLabel($state['type']) ?? null),
                ]),
                Section::make('Header Section Spacing')
                ->description('Customize the spacing of the header sections.')
                ->collapsible()
                ->columns(2)
                ->schema([
                    TextInput::make('header_top_spacing')->numeric()
                    ->helperText('Set the spacing between the top of the page and the first line of the header in pixels.'),
                    TextInput::make('header_between_line_spacing')->numeric()
                    ->helperText('Set the spacing between the first and second lines of the header in pixels.'),
                    TextInput::make('header_bottom_spacing')->numeric()
                    ->helperText('Set the spacing between the second line and the bottom of the header in pixels.'),
                ]),
                TextInput::make('search_box_size')
                ->label('Search Box Size (1024px and above)')
                ->numeric()
                ->helperText('This setting adjusts the search box size on screens wider than 1024px. Best practice is to use a value between 200px and 260px for optimal visibility.'),

            TextInput::make('lg_search_box_size')
                ->label('Search Box Size (1280px and above)')
                ->numeric()
                ->helperText('This setting adjusts the search box size on screens wider than 1280px. Best practice is to use a value between 200px and 350px for optimal visibility.')


            ]);
    }
}
