<?php

namespace Adfox\Appearance\Filament\Pages;

use App\Settings\AdTemplateSettings;
use App\Settings\AppearanceSettings;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\ViewField;
use Filament\Forms\Form;
use Filament\Pages\SettingsPage;

class ManageAdTemplate extends SettingsPage
{
    protected static ?string $title = 'Ad Template';
    protected static ?string $navigationLabel = 'Ad Template';
    protected static ?string $navigationGroup = 'Appearance';

    protected static string $settings = AdTemplateSettings::class;

    public ?array $data = [];

    // protected function mutateFormDataBeforeSave(array $data): array
    // {
    //     $bannerData=$data['banner_data'];
    //     return $data;
    // }
    public function form(Form $form): Form
    {
        return $form
            ->schema([
                TextInput::make('max_line')
                ->numeric()
                ->columnSpanFull()
                ->helperText('Specify the maximum number of lines to display in the ad title. This controls how much text is visible before truncation.')
                ->minValue(1),
                ViewField::make('theme')
                ->view('appearance::filament.fields.ad-template')
                ])
            ->statePath('data');
    }
}
