<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('order_upgrades', function (Blueprint $table) {
            DB::statement("ALTER TABLE `order_upgrades` MODIFY COLUMN `status` ENUM('completed', 'refunded', 'failed', 'pending')");
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('order_upgrades', function (Blueprint $table) {
            DB::statement("ALTER TABLE `order_upgrades` MODIFY COLUMN `status` ENUM('completed', 'refunded', 'failed')");
        });
    }
};
