<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('reported_ads', function (Blueprint $table) {
            $table->id();
            $table->text('reason');
            $table->enum('status', ['pending', 'seen'])->default('pending');
            $table->foreignUuid('user_id')->constrained('users')->onDelete('no action');
            $table->foreignUuid('ad_id')->constrained('ads')->onDelete('no action');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('reported_ads');
    }
};
