<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Address;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;

class StoreContact extends Mailable implements ShouldQueue
{
    use Queueable, SerializesModels;

    public $name;

    public $email;

    public $phone;

    public $message;

    /**
     * Create a new message instance.
     */
    public function __construct($name, $email, $phone, $message)
    {
        $this->name = $name;

        $this->email = $email;

        $this->phone = $phone;

        $this->message = $message;
    }

    /**
     * Get the message envelope.
     */
    public function envelope(): Envelope
    {
        $fromAddress = new Address(config('mail.from.address'), config('mail.from.name'));
        $replyTo = new Address($this->email, $this->name);
        return new Envelope(
            from: $fromAddress,
            replyTo: [$replyTo],
            subject: trans(':name has sent a message from the contact form', ['name' => $this->name]),
        );
    }

    /**
     * Get the message content definition.
     */
    public function content(): Content
    {
        return new Content(
            markdown: 'emails.store-contact',
        );
    }

    /**
     * Get the attachments for the message.
     *
     * @return array<int, \Illuminate\Mail\Mailables\Attachment>
     */
    public function attachments(): array
    {
        return [];
    }
}
