<?php

namespace App\Jobs;

use App\Notifications\WalletTransactionNotification;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class WalletTransactionEmail implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    public $user;
    public $walletTransaction;
    public $subject;
    public $line;
    /**
     * Create a new job instance.
     */
    public function __construct($user, $walletTransaction, $subject)
    {
        $this->user = $user;
        $this->walletTransaction = $walletTransaction;
        $this->subject = $subject;
    }

    /**
     * Execute the job.
     */
    public function handle(): void
    {
        $this->user->notify(new WalletTransactionNotification($this->walletTransaction, $this->subject));
    }
}
