<?php

namespace Adfox\VehicleRentalMarketplace\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Spatie\Translatable\HasTranslations;

class VehicleModel extends Model
{
    use HasFactory, HasTranslations;
    protected $fillable = [
        'name',
        'slug',
        'order',
        'make_id'
    ];
    public $translatable = ['name'];
    public function vehicleRentals()
    {
        return $this->hasMany(VehicleRentalAd::class);
    }
    public function make()
    {
        return $this->belongsTo(VehicleMake::class,'make_id');
    }
}
