<?php

namespace Adfox\VehicleRentalMarketplace\Livewire;

use Adfox\VehicleRentalMarketplace\Models\VehicleCarBooking;
use App\Settings\PaymentSettings;
use Illuminate\Support\Str;
use Livewire\Component;

class VehicleBookingHistory extends Component
{
    public $bookingDetails;
    public $tax;

    public function mount($id)
    {
        $this->bookingDetails = VehicleCarBooking::find($id);
        $paymentSettings = app(PaymentSettings::class);

        if ($paymentSettings->enable_tax) {
            if ($paymentSettings->tax_type === 'percentage') {
                // Calculate tax as a percentage of the subtotal
                $this->tax = (($this->bookingDetails->ads->price * $this->bookingDetails->days) * $paymentSettings->tax_rate) / 100;
            } else if ($paymentSettings->tax_type === 'fixed') {
                // Apply a fixed tax rate
                $this->tax = $paymentSettings->tax_rate;
            }
        } else {
            // No tax applied
            $this->tax = 0;
        }
    }

    public function render()
    {
        return view('vehicle-rental-marketplace::livewire.vehicle-booking-history');
    }
}
