<?php

namespace Adfox\VehicleRentalMarketplace\Filament\Resources;

use Adfox\VehicleRentalMarketplace\Filament\Clusters\VehicleRental;
use Adfox\VehicleRentalMarketplace\Filament\Resources\VehicleMakeResource\Pages;
use Adfox\VehicleRentalMarketplace\Filament\Resources\VehicleMakeResource\RelationManagers;
use Adfox\VehicleRentalMarketplace\Filament\Resources\VehicleMakeResource\RelationManagers\ModelRelationManager;
use Adfox\VehicleRentalMarketplace\Models\VehicleMake;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Concerns\Translatable;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;

class VehicleMakeResource extends Resource
{
    use Translatable;

    protected static ?string $model = VehicleMake::class;
    protected static ?string $cluster = VehicleRental::class;
    protected static ?string $modelLabel='Make';
    protected static ?string $navigationIcon = 'heroicon-o-building-office';
    protected static ?int $navigationSort = 1;
    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                Forms\Components\Textarea::make('name')
                ->required()
                ->maxLength(65535),
                Forms\Components\TextInput::make('order')
                ->required()
                ->numeric()
                ->maxLength(255),
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->reorderable('order')
            ->columns([
                Tables\Columns\TextColumn::make('name')
            ])
            ->filters([
                //
            ])
            ->actions([
                Tables\Actions\EditAction::make(),
                Tables\Actions\DeleteAction::make(),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            ModelRelationManager::class
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListVehicleMakes::route('/'),
            'create' => Pages\CreateVehicleMake::route('/create'),
            'edit' => Pages\EditVehicleMake::route('/{record}/edit'),
        ];
    }
}
