<?php

namespace Adfox\VehicleRentalMarketplace\Filament\Resources;

use Adfox\VehicleRentalMarketplace\Filament\Clusters\VehicleRental;
use Adfox\VehicleRentalMarketplace\Filament\Resources\VehicleFuelTypeResource\Pages;
use Adfox\VehicleRentalMarketplace\Filament\Resources\VehicleFuelTypeResource\RelationManagers;
use Adfox\VehicleRentalMarketplace\Models\VehicleFuelType;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Concerns\Translatable;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;

class VehicleFuelTypeResource extends Resource
{
    use Translatable;

    protected static ?string $model = VehicleFuelType::class;
    protected static ?string $cluster = VehicleRental::class;
    protected static ?string $modelLabel='Fuel Type';
    protected static ?string $navigationIcon = 'heroicon-o-rocket-launch';
    protected static ?int $navigationSort = 2;
    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                Forms\Components\Textarea::make('name')
                ->required()
                ->maxLength(65535),
                Forms\Components\TextInput::make('order')
                ->required()
                ->numeric()
                ->maxLength(255),
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->reorderable('order')
            ->columns([
                Tables\Columns\TextColumn::make('name'),

            ])
            ->filters([
                //
            ])
            ->actions([
                Tables\Actions\EditAction::make(),
                Tables\Actions\DeleteAction::make(),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ManageVehicleFuelTypes::route('/'),
        ];
    }
}
