<?php

namespace Adfox\VehicleRentalMarketplace\Database\Seeders;

use Adfox\VehicleRentalMarketplace\Models\VehicleMake;
use Adfox\VehicleRentalMarketplace\Models\VehicleModel;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class VehicleMakeSeeder extends Seeder
{
    public function run()
    {
        $makesAndModels = [
            'Toyota' => ['Corolla', 'Camry', 'Prius', 'RAV4'],
            'Honda' => ['Civic', 'Accord', 'CR-V', 'Fit'],
            'Ford' => ['Focus', 'Mustang', 'F-150', 'Explorer'],
            'BMW' => ['X3', 'X5', '3 Series', '5 Series'],
            'Tesla' => ['Model S', 'Model 3', 'Model X', 'Model Y'],
        ];
        $makeOrder=1;
        foreach ($makesAndModels as $makeName => $models) {
            $make = VehicleMake::create([
                'name' => $makeName,
                'order' =>$makeOrder,
            ]);
            $modelOrder=1;
            foreach ($models as $modelName) {
                VehicleModel::create([
                    'name' => $modelName,
                    'make_id' => $make->id,
                    'order' =>$modelOrder,
                ]);
                $modelOrder++;
            }
            $makeOrder++;
        }
    }
}
