<?php

namespace Adfox\VehicleRentalMarketplace\Database\Seeders;

// use Illuminate\Database\Console\Seeds\WithoutModelEvents;

use Adfox\VehicleRentalMarketplace\Database\Seeders\Settings\AppearanceSettingsSeeder;
use Adfox\VehicleRentalMarketplace\Database\Seeders\Settings\GeneralSettingsSeeder;
use Database\Seeders\AdConditionsSeeder;
use Database\Seeders\BannerSeeder;
use Database\Seeders\CitiesTableSeeder;
use Database\Seeders\CountriesTableSeeder;
use Database\Seeders\CurrencySeeder;
use Database\Seeders\FieldTemplateSeeder;
use Database\Seeders\FooterSeeder;
use Database\Seeders\LanguagesSeeder;
use Database\Seeders\PackageSeeder;
use Database\Seeders\PagesSeeder;
use Database\Seeders\PlanSeeder;
use Database\Seeders\PriceTypesSeeder;
use Database\Seeders\PromotionsSeeder;
use Database\Seeders\StatesTableSeeder;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Schema;

class DatabaseSeeder extends Seeder
{
    /**
     * Seed the application's database.
     */
    public function run(): void
    {

        $this->call([
            PromotionsSeeder::class,
            PagesSeeder::class,
            CurrencySeeder::class,
            PriceTypesSeeder::class,
            AdConditionsSeeder::class,
            LanguagesSeeder::class,
            PackageSeeder::class,
            FooterSeeder::class,
            CountriesTableSeeder::class,
            StatesTableSeeder::class,
            CitiesTableSeeder::class,
            AppearanceSettingsSeeder::class,
            GeneralSettingsSeeder::class
        ]);

        if(app('filament')->hasPlugin('subscription')){
            $this->call([PlanSeeder::class]);
        }
        if(app('filament')->hasPlugin('appearance')){
            $this->call([BannerSeeder::class]);
        }

        if(Schema::hasTable('vehicle_makes') && Schema::hasTable('vehicle_models')){
            $this->call([VehicleMakeSeeder::class]);
        }
        if(Schema::hasTable('vehicle_features')){
            $this->call([VehicleFeatureSeeder::class]);
        }
        if(Schema::hasTable('vehicle_fuel_types')){
            $this->call([VehicleFuelTypeSeeder::class]);
        }
        if(Schema::hasTable('vehicle_transmissions')){
            $this->call([VehicleTransmissionSeeder::class]);
        }
    }
}
