<?php

namespace Adfox\Subscription\Filament\Resources;

use Adfox\Subscription\Filament\Resources\SubscriptionResource\Pages;
use Adfox\Subscription\Filament\Resources\SubscriptionResource\RelationManagers\InvoicesRelationManager;
use App\Models\Subscription;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Columns\TextColumn;
use Filament\Tables\Table;

class SubscriptionResource extends Resource
{
    protected static ?string $model = Subscription::class;
    protected static ?string $navigationGroup = 'Subscription Management';

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                //
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                TextColumn::make('subscriber.name'),
                TextColumn::make('plan.name'),
                TextColumn::make('status')
                ->formatStateUsing(fn(string $state): string => __("messages.t_{$state}")),
                TextColumn::make('starts_at')
                ->date('d/m/Y'),
                TextColumn::make('ends_at')
                ->date('d/m/Y'),
                TextColumn::make('cancels_at')
                ->date('d/m/Y'),


            ])
            ->filters([
                //
            ])
            ->actions([
                Tables\Actions\ViewAction::make(),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            InvoicesRelationManager::class,
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListSubscriptions::route('/'),
            // 'create' => Pages\CreateSubscription::route('/create'),
            // 'edit' => Pages\EditSubscription::route('/{record}/edit'),
            'view' => Pages\ViewSubscription::route('/{record}'),
        ];
    }
}
