<?php

namespace Adfox\Subscription\Filament\Resources;

use Adfox\Subscription\Filament\Resources\PlanResource\Pages;
use App\Models\Plan;
use App\Models\Promotion;
use Filament\Forms\Components\Hidden;
use Filament\Forms\Components\Repeater;
use Filament\Forms\Components\RichEditor;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\Textarea;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\Toggle;
use Filament\Forms\Form;
use Filament\Forms\Get;
use Filament\Resources\Concerns\Translatable;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Columns\TextColumn;
use Filament\Tables\Columns\ToggleColumn;
use Filament\Tables\Table;
use Filament\Forms\Components\Component;
use Filament\Forms\Components\Contracts\CanDisableOptions;
use Filament\Forms\Set;
use Illuminate\Support\HtmlString;
use Illuminate\Support\Str;

class PlanResource extends Resource
{
    use Translatable;
    protected static ?string $model = Plan::class;

    protected static ?string $navigationGroup = 'Subscription Management';

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                TextInput::make('name')
                    ->required()
                    ->maxLength(80)
                    ->unique()
                    ->live(onBlur: true)
                    ->afterStateUpdated(fn(Set $set, ?string $state) => $set('slug', Str::slug($state))),
                Hidden::make('slug'),
                Toggle::make('is_active')
                    ->inline(false),
                    // TextInput::make('price_id')
                    // ->helperText(new HtmlString('Enter the unique identifier for the pricing plan you created in your <b>Stripe dashboard</b>. You can find your Price IDs in the Stripe Dashboard or <a style="text-decoration:underline" href="https://docs.stripe.com/products-prices/manage-prices" target="blank"><b>click here</b></a> to learn more about Stripe prices.'))
                    // ->required(),
                TextInput::make('price')
                    ->required()
                    ->helperText('Set the price for the subscription plan. Be cautious when changing the price, as every update will create a new price in Stripe. The new price will take effect in the next subscription cycle for existing subscriptions and will not affect the current billing period.')
                    ->numeric()
                    ->minValue(0),

                Textarea::make('description')
                    ->required()
                    ->maxLength(280)
                    ->columnSpanFull(),

                Repeater::make('features')
                    ->columnSpanFull()
                    ->collapsed()
                    ->relationship()
                    ->itemLabel(fn (array $state): ?string => $state['name'] ?? null)
                    ->schema([
                        TextInput::make('name')
                            ->required()
                            ->live(onBlur: true),
                        Select::make('type')
                            ->required()
                            ->live()
                            ->options([
                                'ad_count' => 'Ad Count',
                                'promotion' => 'Promotion'
                            ])
                        ->disableOptionWhen(static function (Component & CanDisableOptions $component, string $value, mixed $state) {
                            if($value=='ad_count'){
                            $repeater = $component->getParentRepeater();

                                if (! $repeater) {
                                    return false;
                                }
                               return  collect($repeater->getState())
                                ->pluck(
                                    (string) str($component->getStatePath())
                                        ->after("{$repeater->getStatePath()}.")
                                        ->after('.'),
                                )
                                ->diff(\Arr::wrap($state))
                                ->filter(fn (mixed $siblingItemState): bool => filled($siblingItemState))
                                ->contains($value)
                                ;
                            }else{
                                return false;
                            }

                            }),
                        Select::make('promotion_id')
                        ->visible(fn(Get $get) => $get('type') == 'promotion')
                        ->required(fn(Get $get) => $get('type') == 'promotion')
                        ->disableOptionsWhenSelectedInSiblingRepeaterItems()
                        ->options(Promotion::all()->pluck('name','id'))
                        ,
                        TextInput::make('value')
                            ->required()
                            ->numeric()
                            ->minValue(0),
                        Textarea::make('description')
                            ->columnSpanFull(),
                        ]),
                        Hidden::make('invoice_period')
                            ->default(1)
                        ,
                        Hidden::make('invoice_interval')
                            ->default('month')
                //TODO :Plan feature

                // TextInput::make('active_subscribers_limit')
                // ->helperText('The maximum number of active subscribers allowed for this plan.')
                //     ->numeric(),
                // TextInput::make('signup_fee')
                // ->helperText('A one-time fee charged at the time of signup.')
                // ->default(0),

                // TextInput::make('trial_period')
                // ->helperText('The length of the trial period'),
                // Select::make('trial_interval')
                // ->helperText('The unit of time for the trial period.')
                //     ->options([
                //         'day' => 'Day',
                //         'week' => 'Week',
                //         'month' => 'Month',
                //     ]),
            //     TextInput::make('invoice_period')
            //     ->helperText('Specify how often an invoice is generated for the subscription.(The length of the billing cycle.)')
            //     ->required(),
            // Select::make('invoice_interval')
            //     ->helperText('The unit of time for the billing cycle.')
            //     ->required()
            //     ->default('month')
            //     ->options([
            //         'month' => 'Month',
            //         'annual' => 'Annual'
            //     ]),
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                TextColumn::make('name'),
                TextColumn::make('price'),
                ToggleColumn::make('is_active'),

            ])
            ->filters([
                //
            ])
            ->actions([
                Tables\Actions\EditAction::make(),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListPlans::route('/'),
            'create' => Pages\CreatePlan::route('/create'),
            'edit' => Pages\EditPlan::route('/{record}/edit'),
        ];
    }
}
