<?php

namespace Adfox\Subscription\Console\Commands;

use App\Models\Subscription;
use Adfox\Subscription\Notifications\UpcomingRenewalNotification;
use Carbon\Carbon;
use Illuminate\Console\Command;

class NotifyUpcomingRenewals extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'subscription:notify-upcoming-renewals';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Notify upcoming subscription renewals to the users
     */
    public function handle()
    {
        //Add 5 days from current date
        $todayFromFiveDays=Carbon::now()->addDays(5);
        //Get upcoming active subscription
        $upcomingSubscriptions=Subscription::isActive()->whereDate('ends_at','=',$todayFromFiveDays)->with('plan')->get();
        foreach ($upcomingSubscriptions as $key => $upcomingSubscription) {
            $subscriber=$upcomingSubscription->subscriber;
            if($subscriber){
                //notify about upcoming renewal to the user
                $subscriber->notify(new UpcomingRenewalNotification($subscriber,$upcomingSubscription));
                $this->info('Send successfully');
            }
        }

    }
}
