<div x-data="{
    is_agreed: false
}">
    @if ($this->stripePaymentSettings?->public_key)
        {{-- Form --}}
        <form id="stripe-payment-form" wire:submit.prevent class="dark:text-gray-400">
            @csrf
            <input type="hidden" name="price_id" value="{{ $priceId }}" >
            <input type="hidden" name="customer_id" value="{{ $customerId }}" >
            <input type="hidden" name="plan_id" value="{{ $planId }}" >
            <input type="hidden" name="user_id" value="{{ auth()->id() }}" >
            <div id="stripe-payment-element"></div>
            {{-- Pay --}}
            <label class="mt-1 ">
                <x-filament::input.checkbox name='subscription_agreement' x-model='is_agreed' />
                <span class="ml-1">
                    {{ __('messages.t_subscription_agreement') }}

                </span>
            </label>
            <button id="stripe-payment-button" type="submit" :disabled="!is_agreed"
                class="mt-6 w-full text-[13px] font-semibold flex justify-center bg-primary-600 hover:bg-primary-700 text-white py-4 px-8 rounded tracking-wide focus:outline-none focus:shadow-outline cursor-pointer disabled:!bg-gray-200 disabled:!text-gray-600 disabled:cursor-not-allowed dark:disabled:!bg-zinc-700 dark:disabled:!text-zinc-400">
                {{ __('messages.t_pay_now') }}
            </button>
        </form>
    @endif
</div>
@assets
    <script src="https://js.stripe.com/v3/" defer></script>
@endassets

@script
    <script>
        const stripe = Stripe("{{ $this->stripePaymentSettings?->public_key }}");

        // Payment options
        const options = {
            mode: 'subscription',
            amount: {{$total*100}},
            currency: "{{ $this->stripePaymentSettings?->currency }}".toLowerCase(),
            appearance: {
                theme: 'stripe',
                variables: {
                    colorPrimaryText: '#fff',
                    colorBackground: '#ffffff',
                    colorText: '#30313d',
                    colorDanger: '#df1b41',
                    spacingUnit: '6px',
                    borderRadius: '12px'
                }
            },
        };
        var elements = stripe.elements(options);

        Livewire.on('initialize-stripe-form', function() {
            setTimeout(function() {
                // Stripe public key
                // Create and mount the Payment Element
                const paymentElement = elements.create('payment');
                paymentElement.mount('#stripe-payment-element');
            }, 0);
            const form = document.getElementById('stripe-payment-form');
            const submitBtn = document.getElementById('stripe-payment-button');

            form.addEventListener('submit', async (event) => {

                // We don't want to let default form submission happen here,
                // which would refresh the page.
                event.preventDefault();

                // Prevent multiple form submissions
                if (submitBtn.disabled) {
                    return;
                }

                // Disable form submission while loading
                submitBtn.disabled = true;

                // Trigger form validation and wallet collection
                const {
                    error: submitError
                } = await elements.submit();
                if (submitError) {
                    handleError(submitError);
                    return;
                }
                const formData = new FormData(form);

                const data = {
                    price_id: formData.get('price_id'),
                    customer_id: formData.get('customer_id'),
                    _token: formData.get('_token'), // Include CSRF token if necessary
                    user_id: formData.get('user_id'),
                    plan_id: formData.get('plan_id'),
                };
                const missingKeys = [];
                if (!data.price_id) {
                    missingKeys.push('price_id');
                }
                if (!data.customer_id) {
                    missingKeys.push('customer_id');
                }
                if (!data._token) {
                    missingKeys.push('_token');
                }
                if (!data.user_id) {
                    missingKeys.push('user_id');
                }
                if (!data.plan_id) {
                    missingKeys.push('plan_id');
                }
                if(missingKeys.length>0){
                    new FilamentNotification()
                    .title("{{ __('messages.t_error') }}")
                    .body('Missing or empty values for the following keys:'+missingKeys.join(','))
                    .danger()
                    .send()
                    submitBtn.disabled = false;
                    return ;
                }
                // Create the subscription
                const res = await fetch('/create-subscription', {
                    method: "POST",
                    headers: {
                        'Content-Type': 'application/json',
                    },
                    body: JSON.stringify(data),
                });

                const {
                    type,
                    clientSecret
                } = await res.json();
                const confirmIntent = type === "setup" ? stripe.confirmSetup : stripe.confirmPayment;

                // Confirm the Intent using the details collected by the Payment Element
                const {
                    error
                } = await confirmIntent({
                    elements,
                    clientSecret,
                    confirmParams: {
                        return_url: "{{ url(route('subscription.success')) }}",
                    },
                });

                if (error) {
                    // This point is only reached if there's an immediate error when confirming the Intent.
                    // Show the error to your customer (for example, "payment details incomplete").
                    handleError(error);
                } else {
                    // Your customer is redirected to your `return_url`. For some payment
                    // methods like iDEAL, your customer is redirected to an intermediate
                    // site first to authorize the payment, then redirected to the `return_url`.
                }
            });
            const handleError = (error) => {
                new FilamentNotification()
                    .title("{{ __('messages.t_error') }}")
                    .body(error.message)
                    .danger()
                    .send()
                submitBtn.disabled = false;
            }
        })
    </script>
@endscript
