<?php

namespace Adfox\Razorpay\Filament\Pages;

use App\Settings\RazorpaySettings;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\Toggle;
use Filament\Forms\Form;
use Filament\Pages\SettingsPage;
use App\Models\SettingsProperty;
use Filament\Forms\Components\Placeholder;
use Filament\Forms\Components\SpatieMediaLibraryFileUpload;
use Illuminate\Support\Facades\Config;

class RazorpayPayment extends SettingsPage
{
    protected static ?string $title = 'Razorpay Settings';

    protected static ?string $navigationGroup = 'Payment Gateways';

    protected static ?string $navigationLabel = 'Razorpay';

    protected static ?string $slug = 'manage-razorpay-settings';

    protected static string $settings = RazorpaySettings::class;

    protected static ?int $navigationSort = 21; // Adjust the sort order as needed

    protected function mutateFormDataBeforeSave(array $data): array
    {
        $previousData = app(RazorpaySettings::class);
        $filtered = [];

        foreach ($data as $key => $item) {
            if (property_exists($previousData, $key)) {
                $propertyType = gettype($previousData->$key);

                if (is_null($item) && $propertyType === 'string') {
                    $filtered[$key] = '';
                    continue;
                }
            }
            $filtered[$key] = $item;
        }
        return $filtered;
    }

    public function form(Form $form): Form
    {
        $currenciesConfig = config('money.currencies');
        $currencyCodes = array_keys($currenciesConfig);
        $isDemo = Config::get('app.demo');

        return $form
            ->schema([
                TextInput::make('name')
                    ->label('Razorpay Name')
                    ->required()
                    ->helperText('Name of the Razorpay configuration.'),

                Toggle::make('status')
                    ->label('Enable Razorpay')
                    ->helperText('Toggle to enable or disable Razorpay integration.'),

                SpatieMediaLibraryFileUpload::make('logo')
                    ->label('Razorpay Logo')
                    ->collection('razorpay')
                    ->visibility('public')
                    ->hidden()
                    ->image()
                    ->model(
                        SettingsProperty::getInstance('razorpay.logo'),
                    )
                    ->helperText('Upload the logo for Razorpay integration.'),

                Select::make('currency')
                    ->label('Default Currency')
                    ->options(array_combine($currencyCodes, $currencyCodes))
                    ->required()
                    ->helperText('Default currency for Razorpay transactions.'),

                $isDemo ?
                Placeholder::make('key_id')
                    ->label('Razorpay Key ID')
                    ->content('*****')
                    ->hint('Hidden due to demo mode.') :
                TextInput::make('key_id')
                    ->label('Razorpay Key ID')
                    ->required()
                    ->helperText('Your Razorpay Key ID.'),

                $isDemo ?
                Placeholder::make('key_secret')
                    ->label('Razorpay Key Secret')
                    ->content('*****')
                    ->hint('Hidden due to demo mode.') :
                TextInput::make('key_secret')
                    ->label('Razorpay Key Secret')
                    ->required()
                    ->helperText('Your Razorpay Key Secret.'),

                TextInput::make('exchange_rate')
                    ->label('Exchange Rate')
                    ->numeric()
                    ->required()
                    ->helperText('Exchange rate for currency conversion.')
            ])
            ->columns(2);
    }
}
