<?php

namespace Adfox\Paypal\Filament\Pages;

use App\Settings\PaypalSettings;
use Filament\Forms\Components\FileUpload;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\Toggle;
use Filament\Forms\Form;
use Filament\Pages\SettingsPage;
use App\Models\SettingsProperty;
use Filament\Forms\Components\Placeholder;
use Filament\Forms\Components\SpatieMediaLibraryFileUpload;
use Illuminate\Support\Facades\Config;

class PaypalPayment extends SettingsPage
{
    protected static ?string $title = 'PayPal Settings';

    protected static ?string $navigationGroup = 'Payment Gateways';

    protected static ?string $navigationLabel = 'PayPal';

    protected static ?string $slug = 'manage-paypal-settings';

    protected static string $settings = PaypalSettings::class;

    protected static ?int $navigationSort = 11; // Adjust the sort order as needed

    protected function mutateFormDataBeforeSave(array $data): array
    {
        $previousData = app(PaypalSettings::class);
        $filtered = [];

        foreach ($data as $key => $item) {
            if (property_exists($previousData, $key)) {
                $propertyType = gettype($previousData->$key);
                if (is_null($item) && $propertyType === 'string') {
                    $filtered[$key] = '';
                    continue;
                }
            }
            $filtered[$key] = $item;
        }
        return $filtered;
    }

    public function form(Form $form): Form
    {
        $currenciesConfig = config('money.currencies');
        $currencyCodes = array_keys($currenciesConfig);
        $isDemo = Config::get('app.demo');
        return $form
            ->schema([
                TextInput::make('name')
                    ->label('PayPal Name')
                    ->required()
                    ->helperText('Name of the PayPal configuration.'),

                Toggle::make('status')
                    ->label('Enable PayPal')
                    ->helperText('Toggle to enable or disable PayPal integration.'),


                SpatieMediaLibraryFileUpload::make('logo')
                    ->label('PayPal Logo')
                    ->collection('paypal')
                    ->visibility('public')
                    ->hidden()
                    ->image()
                    ->model(
                        SettingsProperty::getInstance('paypal.logo'),
                    )
                    ->helperText('Upload the logo for PayPal integration.'),

                Select::make('currency')
                    ->label('Default Currency')
                    ->options(array_combine($currencyCodes, $currencyCodes))
                    ->required()
                    ->helperText('Default currency for PayPal transactions.'),

                $isDemo ?
                Placeholder::make('client_id')
                    ->label('PayPal Client ID')
                    ->content('*****')
                    ->hint('Hidden due to demo mode.') :
                TextInput::make('client_id')
                    ->label('PayPal Client ID')
                    ->required()
                    ->helperText('Your PayPal Client ID.'),

                $isDemo ?
                Placeholder::make('client_secret')
                    ->label('PayPal Client Secret')
                    ->content('*****')
                    ->hint('Hidden due to demo mode.') :
                TextInput::make('client_secret')
                    ->label('PayPal Client Secret')
                    ->required()
                    ->helperText('Your PayPal Client Secret.'),

                TextInput::make('exchange_rate')
                    ->label('Exchange Rate')
                    ->numeric()
                    ->required()
                    ->helperText('Exchange rate for currency conversion.')
            ])
            ->columns(2);
    }
}
