<?php

namespace Adfox\Packages\Livewire;

use App\Models\Ad;
use App\Settings\GeneralSettings;
use App\Settings\SEOSettings;
use Livewire\Attributes\On;
use Livewire\Attributes\Url;
use Livewire\Component;
use Illuminate\Support\Facades\Auth;
use Artesaos\SEOTools\Traits\SEOTools as SEOToolsTrait;

class ChoosePackage extends Component
{
    use SEOToolsTrait;

    public $current = 'package-details';

    #[Url(keep: true)]
    public $pkg_type = 'multiple';

    #[Url]
    public $ad_id;

    public $selectedItems = [];

    public $steps = [
        'package-details',
        'package-payment'
    ];
    public $fromUrl;

    /**
     * Mount the component and process the Ad and its promotions.
     *
     * @param int $id The Ad ID.
     */
    public function mount()
    {
        if ($this->ad_id) {
            $this->initializeAd();
        }
        $this->fromUrl=url()->previous();
        $this->setSeoData();
    }

    /**
    * Set SEO data
    */
    protected function setSeoData()
    {
        $generalSettings = app(GeneralSettings::class);
        $seoSettings = app(SEOSettings::class);


        $separator = $generalSettings->separator ?? '-';
        $siteName = $generalSettings->site_name ?? app_name();

        $title = __('messages.t_seo_buy_packages_page_title') . " $separator " . $siteName;
        $description = $seoSettings->meta_description;

        $this->seo()->setTitle($title);
        $this->seo()->setDescription($description);
    }


    /**
     * Initialize the Ad and ensure it belongs to the authenticated user.
     */
    protected function initializeAd()
    {
        $ad = Ad::find($this->ad_id);

        // Unauthorized access handling
        if (!$ad || $ad->user_id != Auth::id()) {
            abort(403, __('messages.unauthorized_action'));
        }
    }

    /**
     * Toggle the selected items.
     */
    #[On('selected-package-items')]
    public function toggleItems($selectedItems)
    {
        $this->selectedItems = $selectedItems;
    }

    /**
     * Move to the next step in the process.
     */
    #[On('next-step')]
    public function next()
    {
        $currentIndex = array_search($this->current, $this->steps);

        if ($currentIndex !== false && isset($this->steps[$currentIndex + 1])) {
            $this->current = $this->steps[$currentIndex + 1];
        }
    }

    /**
     * Move to the previous step or redirect to home if at the first step.
     */
    public function back()
    {
        $currentIndex = array_search($this->current, $this->steps);

        if ($currentIndex === 0) {
            // Redirect to home if at the first step
            return redirect($this->fromUrl??route('home'));
        }

        if ($currentIndex !== false && isset($this->steps[$currentIndex - 1])) {
            $this->current = $this->steps[$currentIndex - 1];
        }
    }

    /**
     * Render the component view.
     *
     * @return \Illuminate\View\View The view to render.
     */
    public function render()
    {
        return view('packages::choose-package');
    }
}
