<?php

namespace Adfox\Packages\Filament\Pages;

use App\Settings\PackageSettings;
use App\Settings\SubscriptionSettings;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\Toggle;
use Filament\Forms\Form;
use Filament\Pages\SettingsPage;

class PackageSetup extends SettingsPage
{
    protected static ?string $title = 'Package Settings';

    protected static ?string $navigationGroup = 'Package Management';

    protected static ?string $navigationLabel = 'Package Settings';

    protected static ?string $slug = 'manage-package-settings';

    protected static string $settings = PackageSettings::class;

    protected static ?int $navigationSort = 12; // Adjust the sort order as needed

    protected function mutateFormDataBeforeSave(array $data): array
    {
        $previousData = app(PackageSettings::class);
        $filtered = [];

        foreach ($data as $key => $item) {
            // Check if the property exists in the GeneralSettings class
            if (property_exists($previousData, $key)) {
                // Get the type of the property
                $propertyType = gettype($previousData->$key);

                // If the item is null and the property type is string, set it to an empty string
                if (is_null($item) && $propertyType === 'string') {
                    $filtered[$key] = '';
                    continue;
                }
            }
            // For other cases, just copy the item as is
            $filtered[$key] = $item;
        }
        return $filtered;
    }


    public function afterSave(){
        //Disable subscription if package enabled
        $subscriptionSettings=app(SubscriptionSettings::class);
        if(isset($this->data['status']) && $this->data['status']){
            $subscriptionSettings->status=false;
            $subscriptionSettings->combine_subscriptions_and_orders=false;
            $subscriptionSettings->save();
        }
    }
    public function form(Form $form): Form
    {
        return $form
            ->schema([
                Toggle::make('status')
                    ->label('Enable Packages')
                    ->helperText('Toggle to enable or disable Package Management.'),

                TextInput::make('free_ad_limit')
                    ->numeric()
                    ->minValue(1)
                    ->label('Free Ad Limit')
                    ->placeholder('Enter the number of free ads allowed')
                    ->required(),

                Select::make('ad_renewal_period')
                    ->label('Ad Renewal Period')
                    ->options([
                        'month' => 'Monthly',
                        'year' => 'Yearly'
                    ])
                    ->required()
                    ->helperText('Select the period after which ad limits will reset.'),


            ])
            ->columns(2);
    }
}
