<?php

namespace Adfox\Packages\Filament\App\Pages;

use Filament\Pages\Page;

use App\Models\OrderPackageItem;
use App\Settings\GeneralSettings;
use App\Settings\PackageSettings;
use App\Settings\SEOSettings;
use Livewire\Component;
use Filament\Tables\Concerns\InteractsWithTable;
use Filament\Tables\Contracts\HasTable;
use Filament\Tables\Table;
use Filament\Tables\Columns\TextColumn;
use Filament\Tables\Filters\SelectFilter;
use Illuminate\Support\Carbon;
use Filament\Forms\Contracts\HasForms;
use Filament\Forms\Concerns\InteractsWithForms;
use Filament\Tables\Grouping\Group;
use Livewire\Attributes\Url;
use Artesaos\SEOTools\Traits\SEOTools as SEOToolsTrait;
use Illuminate\Support\Facades\Schema;

class MyPackages extends Page implements HasForms, HasTable
{
    use SEOToolsTrait;
    use InteractsWithTable;
    use InteractsWithForms;
    protected static ?string $navigationIcon = 'bill';

    protected static string $view = 'packages::filament.app.pages.my-packages';
    #[Url(as: 'ref', keep: true)]
    public $referrer = '/';
    protected static ?int $navigationSort = 6;

    public static function getNavigationLabel(): string
    {
        return __('messages.t_my_packages');
    }
    public  function getTitle(): string
    {
        return __('messages.t_my_packages');
    }
    /**
     * Mount the component
     */
    public function mount()
    {
        $this->setSeoData();
    }

    /**
     * Defines the table structure for displaying package items.
     */
    public function table(Table $table): Table
    {
        return $table
            ->query(
                OrderPackageItem::query()
                    ->whereHas('orderPackage', function ($query) {
                        $query->where('user_id', auth()->id());
                    })
            )
            ->groups([
                Group::make('orderPackage.id')
                ->label(__('messages.t_order_id'))
                ->getDescriptionFromRecordUsing(
                    function (OrderPackageItem $record): string {
                        $paymentMethod=$record->orderPackage->payment_method=='offline'?__('messages.t_offline'):getPaymentLabel($record->orderPackage->payment_method);
                        return __('messages.t_payment_method').': ' . $paymentMethod .
                               ', '.__('messages.t_taxes').': ' . $record->orderPackage->taxes_value .
                               ', '.__('messages.t_subtotal').': ' . $record->orderPackage->subtotal_value .
                               ', '.__('messages.t_total').': ' . $record->orderPackage->total_value;
                    }
                )
            ])
            ->defaultGroup('orderPackage.id')
            ->columns([
                TextColumn::make('name')->label(__('messages.t_package_name'))
                ->formatStateUsing(fn($record)=>$record?->packageItem?->promotion ? $record?->packageItem?->promotion->promotion->name : __('messages.t_extra_ad_postings')),
                TextColumn::make('activation_date')->label(__('messages.t_activation_date'))->date('d/m/Y'),
                TextColumn::make('expiry_date')->label(__('messages.t_expiry_date'))->date('d/m/Y'),
                TextColumn::make('purchased')->label(__('messages.t_purchased')),
                TextColumn::make('available')->label(__('messages.t_available')),
                TextColumn::make('used')->label(__('messages.t_used')),

            ])
            ->filters([

            ]);
    }

    /**
    * Set SEO data
    */
    protected function setSeoData()
    {
        $generalSettings = app(GeneralSettings::class);
        $seoSettings = app(SEOSettings::class);


        $separator = $generalSettings->separator ?? '-';
        $siteName = $generalSettings->site_name ?? app_name();

        $title = __('messages.t_seo_my_packages_page_title') . " $separator " . $siteName;
        $description = $seoSettings->meta_description;

        $this->seo()->setTitle($title);
        $this->seo()->setDescription($description);
    }
    public static function isDiscovered(): bool
    {
        return (app('filament')->hasPlugin('packages') && (Schema::hasTable('settings') && app(PackageSettings::class)->status));
    }

}
