<?php

namespace Adfox\OfflinePayment;

use Filament\Panel;
use Filament\Contracts\Plugin;

class OfflinePaymentPlugin implements Plugin
{
    public function getId(): string
    {
        return 'offline-payment';
    }

    public function register(Panel $panel): void
    {
        if ($panel->getId() == 'admin') {
            $panel->discoverResources(
                in: __DIR__ . '/Filament/Resources',
                for: 'Adfox\\OfflinePayment\\Filament\\Resources'
            )->discoverPages(
                    in: __DIR__ . '/Filament/Pages',
                    for: 'Adfox\\OfflinePayment\\Filament\\Pages'
                );
        }
    }

    public function boot(Panel $panel): void
    {
    }
}
