<?php

namespace Adfox\MapView\Livewire;

use App\Models\Ad;
use App\Settings\GoogleLocationKitSettings;
use Livewire\Component;
use Livewire\Attributes\On;



class MapView extends Component
{
    public $ads = [];
    public $selectedAdId = null;
    public $selectedAd = null;

    public function mount($ads)
    {
        $this->ads = $ads['data'];
    }

    #[On('select-ad')]
    public function selectAd($adId)
    {
       $this->selectedAdId = $adId;
       $this->selectedAd=Ad::find($this->selectedAdId);

    }

    public function getGoogleSettingsProperty()
    {
        return app(GoogleLocationKitSettings::class);
    }

    public function render()
    {
        return view('map-view::map-view');
    }
}
