<?php

namespace Adfox\MapView\Filament\Pages;

use App\Settings\FeedbackSettings;
use App\Settings\MapViewSettings;
use Filament\Forms\Components\Toggle;
use Filament\Forms\Form;
use Filament\Pages\SettingsPage;

class ManageMapViewSettings extends SettingsPage
{
    protected static ?string $title = 'Map view Settings';

    protected static ?string $navigationGroup = 'Appearance';

    protected static ?string $navigationLabel = 'Map view Settings';

    protected static ?string $slug = 'manage-map-view-settings';

    protected static string $settings = MapViewSettings::class;

    protected static ?int $navigationSort = 5;

    public function form(Form $form): Form
    {
        return $form
            ->schema([
                Toggle::make('enable')
                ->label('Enable Map View')
                ->helperText('If enabled, the map view will be visible on the ad search page.'),
                Toggle::make('show_filter_popup')
                ->label('Display Filter in Popup')
                ->helperText('Enable this option to display the filter as a popup. If disabled, the filter will be displayed on the left side.'),
                Toggle::make('enable_container_max_width')
                ->label('Enable container max width')
                ->helperText("Toggle to enable or disable the container's maximum width. When enabled, the content will be constrained to a centered container; when disabled, the content will take the full width of the screen. Note: This setting only affects the desktop view on the ad list page.")


            ])
            ->columns(2);
    }
}
