<?php

namespace Adfox\Flutterwave\Filament\Pages;

use App\Settings\FlutterwaveSettings;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\Toggle;
use Filament\Forms\Form;
use Filament\Pages\SettingsPage;
use App\Models\SettingsProperty;
use Filament\Forms\Components\Placeholder;
use Filament\Forms\Components\SpatieMediaLibraryFileUpload;
use Illuminate\Support\Facades\Config;

class FlutterwavePayment extends SettingsPage
{
    protected static ?string $title = 'Flutterwave Settings';

    protected static ?string $navigationGroup = 'Payment Gateways';

    protected static ?string $navigationLabel = 'Flutterwave';

    protected static ?string $slug = 'manage-flutterwave-settings';

    protected static string $settings = FlutterwaveSettings::class;

    protected static ?int $navigationSort = 12; // Adjust the sort order as needed

    protected function mutateFormDataBeforeSave(array $data): array
    {
        $previousData = app(FlutterwaveSettings::class);
        $filtered = [];

        foreach ($data as $key => $item) {
            // Check if the property exists in the GeneralSettings class
            if (property_exists($previousData, $key)) {
                // Get the type of the property
                $propertyType = gettype($previousData->$key);

                // If the item is null and the property type is string, set it to an empty string
                if (is_null($item) && $propertyType === 'string') {
                    $filtered[$key] = '';
                    continue;
                }
            }
            // For other cases, just copy the item as is
            $filtered[$key] = $item;
        }
        return $filtered;
    }


    public function form(Form $form): Form
    {
        $currenciesConfig = config('money.currencies');
        $currencyCodes = array_keys($currenciesConfig);
        $isDemo = Config::get('app.demo');
        return $form
            ->schema([
                TextInput::make('name')
                    ->label('Flutterwave Name')
                    ->required()
                    ->helperText('Name of the Flutterwave configuration.'),

                Toggle::make('status')
                    ->label('Enable Flutterwave')
                    ->helperText('Toggle to enable or disable Flutterwave integration.'),

                SpatieMediaLibraryFileUpload::make('logo')
                    ->label('Flutterwave Logo')
                    ->collection('flutterwave')
                    ->visibility('public')
                    ->hidden()
                    ->image()
                    ->model(
                        SettingsProperty::getInstance('flutterwave.logo'),
                    )
                    ->helperText('Upload the logo for Flutterwave integration.'),

                Select::make('currency')
                    ->label('Default Currency')
                    ->options(array_combine($currencyCodes, $currencyCodes))
                    ->required()
                    ->helperText('Default currency for Flutterwave transactions.'),

                $isDemo ?
                Placeholder::make('public_key')
                    ->label('Flutterwave Public Key')
                    ->content('*****')
                    ->hint('Hidden due to demo mode.') :
                TextInput::make('public_key')
                    ->label('Flutterwave Public Key')
                    ->required()
                    ->helperText('Your Flutterwave Public Key.'),

                $isDemo ?
                Placeholder::make('secret_key')
                    ->label('Flutterwave Secret Key')
                    ->content('*****')
                    ->hint('Hidden due to demo mode.') :
                TextInput::make('secret_key')
                    ->label('Flutterwave Secret Key')
                    ->required()
                    ->helperText('Your Flutterwave Secret Key.'),

                $isDemo ?
                Placeholder::make('encryption_key')
                    ->label('Flutterwave Encryption Key')
                    ->content('*****')
                    ->hint('Hidden due to demo mode.') :
                TextInput::make('encryption_key')
                    ->label('Flutterwave Encryption Key')
                    ->required()
                    ->helperText('Your Flutterwave Encryption Key.'),

                TextInput::make('exchange_rate')
                    ->label('Exchange Rate')
                    ->numeric()
                    ->required()
                    ->helperText('Exchange rate for currency conversion.')
            ])
            ->columns(2);
    }
}
