<div>
    <livewire:layout.header  lazy  />
    <div class="container mx-auto px-4 py-10">
        <div class="grid md:grid-cols-3 gap-x-6">
            <div class="col-span-2">
                <div class="flex justify-between items-center mb-10">
                    <h2 class="text-xl font-semibold">{{ __('messages.t_feedbacks_about', ['name' => $sellerName]) }}</h2>
                </div>

                <div class="flex flex-col md:flex-row  justify-between items-center mb-4">
                    <div class="flex flex-col md:flex-row justify-between items-center mb-4">
                        <div class="grid grid-cols-3 gap-10 mb-4 font-semibold">
                            <div class="text-center flex items-center flex-col">
                                <div class="text-green-500 flex gap-x-1">
                                    <x-heroicon-o-face-smile class="w-6 h-6" />
                                    <span>{{ $positiveCount }}</span>
                                </div>
                                <span>{{ __('messages.t_positive') }}</span>
                            </div>
                            <div class="text-center flex items-center flex-col">
                                <div class="text-orange-500 flex gap-x-1">
                                    <x-heroicon-o-face-frown class="w-6 h-6" />
                                    <span>{{ $neutralCount }}</span>
                                </div>
                                <span>{{ __('messages.t_neutral') }}</span>
                            </div>
                            <div class="text-center flex items-center flex-col">
                                <div class="text-red-500 flex gap-x-1">
                                    <x-heroicon-o-face-frown class="w-6 h-6" />
                                    <span>{{ $negativeCount }}</span>
                                </div>
                                <span>{{ __('messages.t_negative') }}</span>
                            </div>
                        </div>
                    </div>

                    @if ($this->feedbackAction->isVisible())
                    {{ $this->feedbackAction }}
                    @endif
                </div>

                <livewire:feedback-list :$sellerId   />


            </div>

            <div class="col-span-1 hidden md:block ">
                  <div class="flex items-center flex-col bg-white dark:bg-gray-900/20 p-10 rounded-xl ring-1 ring-gray-950/10 dark:ring-white/10 classic:ring-black">
                    <x-heroicon-o-chat-bubble-bottom-center-text class="w-16 h-16" />
                    <p>{{ __('messages.t_your_feedback_is_very_important') }}</p>
                  </div>
            </div>
        </div>
    </div>
    <x-filament-actions::modals />
</div>
