<?php

namespace Adfox\Appearance\Filament\Pages;

use App\Settings\BannerSettings;
use Filament\Forms\Components\Hidden;
use Filament\Forms\Components\Repeater;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\Toggle;
use Filament\Forms\Form;
use Filament\Forms\Get;
use Filament\Pages\SettingsPage;

class ManageBanner extends SettingsPage
{
    protected static ?string $title = 'Banner Settings';
    protected static ?string $navigationLabel = 'Banner Settings';
    protected static ?string $navigationGroup = 'Appearance';

    protected static string $settings = BannerSettings::class;

    public ?array $data = [];

    // protected function mutateFormDataBeforeSave(array $data): array
    // {
    //     $bannerData=$data['banner_data'];
    //     return $data;
    // }
    public function form(Form $form): Form
    {
        return $form
            ->schema([
                Toggle::make('enable_carousel')
                ->helperText('Toggle to enable or disable the carousel feature on the page.')
                ->columnSpanFull(),
                Toggle::make('enable_pagination_count')
                ->helperText('Toggle to display the pagination count below the carousel.'),
                Toggle::make('enable_autoplay')
                ->helperText('Toggle to enable automatic sliding of carousel items.')
                ->live(),
                TextInput::make('autoplay_interval')
                ->visible(fn(Get $get)=>$get('enable_autoplay'))
                ->numeric()
                ->minValue(0.1)
                ->helperText('Set the time interval (in milliseconds) between each automatic slide. The value must be 100 milliseconds or greater.'),
                ])
            ->statePath('data');
    }
}
